#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Simple duo scale truchetMod01.fsh  by  mrange  
//https://www.shadertoy.com/view/NsGfWK
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// CC0: Simple duo scale truchet
// Read a bit about Wave Function Collapse algorithm to generate truchet like patterns 
// Started implementing it and was immedietly bored by it as I didn't write a shader.
// So instead I revisited the idea of multiscale truchet patterns.
// Created a quick little duo scale truchet.
// Much more fun

#define TIME        iTime
#define RESOLUTION  iResolution

// License: Unknown, author: Unknown, found: don't remember
float hash(vec2 co) {
  return fract(sin(dot(co.xy ,vec2(12.9898,58.233))) * 13758.5453);
}

float df0(vec2 p, float linew) {
  vec2 cp = p - 0.5;
  vec2 cn = round(cp);
  cp -= cn;

  float h0 = hash(cn);
  cp = h0 > 0.5 ? cp : vec2(cp.y, -cp.x);
  float d0 = length(cp-0.5)-0.5;
  float d1 = length(cp+0.5)-0.5;
  
  float d = d0;
  d = min(d, d1);
  
  d = abs(d) - linew*3.0;
  return d;
}

float df1(vec2 p, float linew) {
  vec2 cp = p - 0.5;
  vec2 cn = round(cp);
  cp -= cn;

  float h0 = hash(cn);
  float h1 = hash(cn+123.4);
  
  if (h1 > 0.66) {
    return df0(p*3.0, linew)/3.0;
  }
  
  vec2 cp2 = cp;
  cp2 = abs(cp2);
  cp = h0 > 0.5 ? cp : vec2(cp.y, -cp.x);
  float d0 = length(cp-0.5)-0.5;
  float d1 = length(cp+0.5)-0.5;
  float d2 = length(cp2-0.5)-1.0/6.0;
  
  float d = d0;
  d = min(d, d1);
  d = abs(d) - linew;
  d = min(d, abs(d2)-linew);
  
  return d;
}

float df(vec2 p, float f) {
  float linew = mix(0.0, 0.05, f);
  return df1(p, linew);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  vec2 q = fragCoord/RESOLUTION.xy;
  vec2 p = -1. + 2. * q;
  p.x *= RESOLUTION.x/RESOLUTION.y;
  float aa = 2.0/RESOLUTION.y;
  const float z = 0.25;
  vec2 dp = p;
  const float spd = 0.5;
  const float r = 10.0;
  dp += r*sin(vec2(sqrt(0.5), 1.0)*TIME*spd/r);
  dp /= z;
  float f = mix(0.01, 0.05, texture2D(texture0, 0.00125*dp).x);
  f *= 30.0;
  f = tanh(f);
  float d = df(dp, f)*z;
  vec3 col = vec3(0.01);
  col = mix(col, vec3(0.5*f), smoothstep(aa, -aa, d));
  col = sqrt(col);
  fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

